<?php
/* --------------------------------------------------------------
   RemovedDataFromCache.php 2020-04-29
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Cache\Events;

use Gambio\Core\Cache\Exceptions\InvalidArgumentException;

/**
 * Class RemovedDataFromCache
 *
 * @package Gambio\Core\Cache\Events
 */
class RemovedDataFromCache
{
    /**
     * @var string
     */
    private $namespace;
    
    /**
     * @var string
     */
    private $key;
    
    
    /**
     * RemovedDataFromCache constructor.
     *
     * @param string $namespace
     * @param string $key
     */
    private function __construct(string $namespace, string $key)
    {
        $this->namespace = $namespace;
        $this->key       = $key;
    }
    
    
    /**
     * @param string $namespace
     * @param string $key
     *
     * @return RemovedDataFromCache
     *
     * @throws InvalidArgumentException
     */
    public static function create(string $namespace, string $key): RemovedDataFromCache
    {
        if (strlen($namespace) > 64 || preg_match('/^[A-Za-z0-9_\.]+$/', $namespace) !== 1) {
            throw InvalidArgumentException::forNamespace();
        }
        
        if (strlen($key) > 64 || preg_match('/^[A-Za-z0-9_\.]+$/', $key) !== 1) {
            throw InvalidArgumentException::forKey();
        }
        
        return new self($namespace, $key);
    }
    
    
    /**
     * @return string
     */
    public function namespace(): string
    {
        return $this->namespace;
    }
    
    
    /**
     * @return string
     */
    public function key(): string
    {
        return $this->key;
    }
}